/*
 * Decompiled with CFR 0.152.
 */
package com.android.verity;

import com.android.verity.Utils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class VeritySigner {
    private static void usage() {
        System.err.println("usage: VeritySigner <contentfile> <key.pk8> <sigfile> | <contentfile> <certificate.x509.pem> <sigfile> -verify");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            VeritySigner.usage();
            return;
        }
        Security.addProvider(new BouncyCastleProvider());
        byte[] byArray = Utils.read(stringArray[0]);
        if (stringArray.length > 3 && "-verify".equals(stringArray[3])) {
            X509Certificate x509Certificate = Utils.loadPEMCertificate(stringArray[1]);
            PublicKey publicKey = x509Certificate.getPublicKey();
            byte[] byArray2 = Utils.read(stringArray[2]);
            try {
                if (Utils.verify(publicKey, byArray, byArray2, Utils.getSignatureAlgorithmIdentifier(publicKey))) {
                    System.err.println("Signature is VALID");
                    System.exit(0);
                } else {
                    System.err.println("Signature is INVALID");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            System.exit(1);
        } else {
            PrivateKey privateKey = Utils.loadDERPrivateKey(Utils.read(stringArray[1]));
            byte[] byArray3 = Utils.sign(privateKey, byArray);
            Utils.write(byArray3, stringArray[2]);
        }
    }
}

