/*
 * Decompiled with CFR 0.152.
 */
package com.android.verity;

import com.android.verity.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class BootSignature
extends ASN1Object {
    private ASN1Integer formatVersion;
    private ASN1Encodable certificate;
    private AlgorithmIdentifier algorithmIdentifier;
    private DERPrintableString target;
    private ASN1Integer length;
    private DEROctetString signature;
    private PublicKey publicKey;
    private static final int FORMAT_VERSION = 1;
    private static final int BOOT_IMAGE_HEADER_V1_RECOVERY_DTBO_SIZE_OFFSET = 1632;
    private static final int BOOT_IMAGE_HEADER_V2_DTB_SIZE_OFFSET = 1648;
    private static final int BOOT_IMAGE_HEADER_VERSION_MAXIMUM = 8;

    public BootSignature(String string, int n) {
        this.formatVersion = new ASN1Integer(1L);
        this.target = new DERPrintableString(string);
        this.length = new ASN1Integer(n);
    }

    public BootSignature(byte[] byArray) throws Exception {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        this.formatVersion = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        if (this.formatVersion.getValue().intValue() != 1) {
            throw new IllegalArgumentException("Unsupported format version");
        }
        this.certificate = aSN1Sequence.getObjectAt(1);
        byte[] byArray2 = ((ASN1Object)this.certificate).getEncoded();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        this.publicKey = x509Certificate.getPublicKey();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
        this.algorithmIdentifier = new AlgorithmIdentifier((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0));
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.target = (DERPrintableString)aSN1Sequence3.getObjectAt(0);
        this.length = (ASN1Integer)aSN1Sequence3.getObjectAt(1);
        this.signature = (DEROctetString)aSN1Sequence.getObjectAt(4);
    }

    public ASN1Object getAuthenticatedAttributes() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.target);
        aSN1EncodableVector.add(this.length);
        return new DERSequence(aSN1EncodableVector);
    }

    public byte[] getEncodedAuthenticatedAttributes() throws IOException {
        return this.getAuthenticatedAttributes().getEncoded();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        return this.signature.getOctets();
    }

    public void setSignature(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.signature = new DEROctetString(byArray);
    }

    public void setCertificate(X509Certificate x509Certificate) throws Exception, IOException, CertificateEncodingException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getEncoded());
        this.certificate = aSN1InputStream.readObject();
        this.publicKey = x509Certificate.getPublicKey();
    }

    public byte[] generateSignableImage(byte[] byArray) throws IOException {
        byte[] byArray2 = this.getEncodedAuthenticatedAttributes();
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + byArray2.length);
        for (int i = 0; i < byArray2.length; ++i) {
            byArray3[i + byArray.length] = byArray2[i];
        }
        return byArray3;
    }

    public byte[] sign(byte[] byArray, PrivateKey privateKey) throws Exception {
        byte[] byArray2 = this.generateSignableImage(byArray);
        return Utils.sign(privateKey, byArray2);
    }

    public boolean verify(byte[] byArray) throws Exception {
        if (this.length.getValue().intValue() != byArray.length) {
            throw new IllegalArgumentException("Invalid image length");
        }
        byte[] byArray2 = this.generateSignableImage(byArray);
        return Utils.verify(this.publicKey, byArray2, this.signature.getOctets(), this.algorithmIdentifier);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.formatVersion);
        aSN1EncodableVector.add(this.certificate);
        aSN1EncodableVector.add(this.algorithmIdentifier);
        aSN1EncodableVector.add(this.getAuthenticatedAttributes());
        aSN1EncodableVector.add(this.signature);
        return new DERSequence(aSN1EncodableVector);
    }

    public static int getSignableImageSize(byte[] byArray) throws Exception {
        if (!Arrays.equals(Arrays.copyOfRange(byArray, 0, 8), "ANDROID!".getBytes("US-ASCII"))) {
            throw new IllegalArgumentException("Invalid image header: missing magic");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.getLong();
        int n = byteBuffer.getInt();
        byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byteBuffer.getLong();
        int n4 = byteBuffer.getInt();
        int n5 = n4 + (n + n4 - 1) / n4 * n4 + (n2 + n4 - 1) / n4 * n4 + (n3 + n4 - 1) / n4 * n4;
        int n6 = byteBuffer.getInt();
        if (n6 > 0 && n6 < 8) {
            byteBuffer.position(1632);
            int n7 = byteBuffer.getInt();
            n5 += (n7 + n4 - 1) / n4 * n4;
            byteBuffer.getLong();
            int n8 = byteBuffer.getInt();
            if (n6 == 2) {
                byteBuffer.position(1648);
                int n9 = byteBuffer.getInt();
                n5 += (n9 + n4 - 1) / n4 * n4;
                byteBuffer.getLong();
            }
            if (byteBuffer.position() != n8) {
                throw new IllegalArgumentException("Invalid image header: invalid header length");
            }
        } else {
            n5 += (n6 + n4 - 1) / n4 * n4;
        }
        if ((n5 = (n5 + n4 - 1) / n4 * n4) <= 0) {
            throw new IllegalArgumentException("Invalid image header: invalid length");
        }
        return n5;
    }

    public static void doSignature(String string, String string2, String string3, String string4, String string5) throws Exception {
        byte[] byArray = Utils.read(string2);
        int n = BootSignature.getSignableImageSize(byArray);
        if (n < byArray.length) {
            System.err.println("NOTE: truncating file " + string2 + " from " + byArray.length + " to " + n + " bytes");
            byArray = Arrays.copyOf(byArray, n);
        } else if (n > byArray.length) {
            throw new IllegalArgumentException("Invalid image: too short, expected " + n + " bytes");
        }
        BootSignature bootSignature = new BootSignature(string, byArray.length);
        X509Certificate x509Certificate = Utils.loadPEMCertificate(string4);
        bootSignature.setCertificate(x509Certificate);
        PrivateKey privateKey = Utils.loadDERPrivateKeyFromFile(string3);
        bootSignature.setSignature(bootSignature.sign(byArray, privateKey), Utils.getSignatureAlgorithmIdentifier(privateKey));
        byte[] byArray2 = bootSignature.getEncoded();
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + byArray2.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        Utils.write(byArray3, string5);
    }

    public static void verifySignature(String string, String string2) throws Exception {
        byte[] byArray = Utils.read(string);
        int n = BootSignature.getSignableImageSize(byArray);
        if (n >= byArray.length) {
            throw new IllegalArgumentException("Invalid image: not signed");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, byArray.length);
        BootSignature bootSignature = new BootSignature(byArray2);
        if (!string2.isEmpty()) {
            System.err.println("NOTE: verifying using public key from " + string2);
            bootSignature.setCertificate(Utils.loadPEMCertificate(string2));
        }
        try {
            if (bootSignature.verify(Arrays.copyOf(byArray, n))) {
                System.err.println("Signature is VALID");
                System.exit(0);
            } else {
                System.err.println("Signature is INVALID");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if ("-verify".equals(stringArray[0])) {
            String string = "";
            if (stringArray.length >= 4 && "-certificate".equals(stringArray[2])) {
                string = stringArray[3];
            }
            BootSignature.verifySignature(stringArray[1], string);
        } else {
            BootSignature.doSignature(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
    }
}

