#!/system/bin/sh
# Conditional MagiskHide properties

maybe_set_prop() {
    local prop="$1"
    local contains="$2"
    local value="$3"

    if [[ "$(getprop "$prop")" == *"$contains"* ]]; then
        resetprop -n "$prop" "$value"
    fi
}

# Magisk recovery mode
maybe_set_prop ro.bootmode recovery unknown
maybe_set_prop ro.boot.mode recovery unknown
maybe_set_prop vendor.boot.mode recovery unknown

# MIUI cross-region flash
maybe_set_prop ro.boot.hwc CN GLOBAL
maybe_set_prop ro.boot.hwcountry China GLOBAL

resetprop --delete ro.build.selinux

# SELinux permissive
if [[ "$(cat /sys/fs/selinux/enforce)" == "0" ]]; then
    chmod 640 /sys/fs/selinux/enforce
    chmod 440 /sys/fs/selinux/policy
fi

# Late props which must be set after boot_completed
{
    until [[ "$(getprop sys.boot_completed)" == "1" ]]; do
        sleep 1
    done

    # avoid breaking Realme fingerprint scanners
    resetprop -n ro.boot.flash.locked 1

    # avoid breaking Oppo fingerprint scanners
    resetprop -n ro.boot.vbmeta.device_state locked

    # avoid breaking OnePlus display modes/fingerprint scanners
    resetprop -n vendor.boot.verifiedbootstate green

    # Safetynet (avoid breaking OnePlus display modes/fingerprint scanners on OOS 12)
    resetprop -n ro.boot.verifiedbootstate green
    resetprop -n ro.boot.veritymode enforcing
    resetprop -n vendor.boot.vbmeta.device_state locked

    # Oneplus (avoid breaking OnePlus display modes/fingerprint scanners on OOS 12) 
    resetprop -n ro.is_ever_orange 0

    # Google enforces hardware attestation for devices released with Android 13+
    # https://github.com/kdrag0n/safetynet-fix/issues/224
    # Simply spoof released version to lower one for now
    if [ "$(getprop ro.product.first_api_level)" -ge 33 ]; then
        resetprop -n ro.product.first_api_level 32
    fi
}&
